#
# This awk script converts dineroIII bus2 output (-o2) back into
# din format.  This is useful for simulating a level two cache.
#
# Information on whether a read miss is due to a read, write or
# instruction fetch is lost.  Snoop (-o3) records are not handled.
#

$1 != "BUS2"  { printf "3 0\t" ; print }

$1 == "BUS2" && $2 =="r" { print "0 " $4  }

$1 == "BUS2" && $2 =="w" { print "1 " $4  }

$1 == "BUS2" && $2 !="r" && $2 !="w" { printf "ERROR UNEXPECTED INPUT: " ; print } 

