.\" 
.\"/*************************************************
.\"*     rpld - an IBM style RIPL server            *
.\"*************************************************/
.\"
.\"Copyright (c) 1999, James McKenzie.
.\"                     All rights reserved
.\"Copyright (c) 1998, Christopher Lightfoot.
.\"                     All rights reserved
.\"
.\"By using this file, you agree to the terms and conditions set
.\"forth in the LICENSE file which can be found at the top level of
.\"the rpld distribution.
.\"
.\"IBM is a trademark of IBM Corp.
.\"
.\"
.\"
.\" $Id: rpld.man,v 1.10 1999/09/15 01:22:18 root Exp $;
.\"
.\" $Log: rpld.man,v $
.\" Revision 1.10  1999/09/15 01:22:18  root
.\" #
.\"
.\" Revision 1.9  1999/09/15 00:36:29  root
.\" #
.\"
.\" Revision 1.8  1999/09/15 00:25:57  root
.\" #
.\"
.\" Revision 1.7  1999/09/15 00:22:07  root
.\" #
.\"
.\" Revision 1.6  1999/09/15 00:14:29  root
.\" #
.\"
.\" Revision 1.5  1999/09/14 21:43:30  root
.\" #
.\"
.\" Revision 1.4  1999/09/14 21:37:08  root
.\" #
.\"
.\" Revision 1.3  1999/09/14 21:32:12  root
.\" #
.\"
.\" Revision 1.2  1999/09/14 21:25:59  root
.\" #
.\"
.\" Revision 1.1  1999/09/14 21:00:47  root
.\" #
.\"
.\" Revision 1.1  1999/09/14 17:19:37  root
.\" Initial revision
.\"
.\";
.Dd Sep 14, 1999
.Dt RPLD 8
.Os Linux
.Sh NAME
.Nm rpld
.Nd an RPL/RIPL remote boot server
.Sh SYNOPSIS
.Nm rpld
.Sh WARRANTY
.Nm rpld 
DOES NOT come with ANY WARRANTY, NOT even an IMPLIED WARRANTY.
.Sh DESCRIPTION
.Nm rpld 
will net-boot IBM style RPL boot ROMs. Communication between the client and the
server is done in LLC-1 ui/C frames with the source and destination SAP both 
being 0xfc. On booting the client transmits a FIND frame containing the client's
MAC address, adapter type and frame length. The server replies with a FOUND frame
containing the server's MAC address and a possibly smaller frame length. The
client issues a SEND.FILE.REQUEST frame requesting the first block of the boot
file. The server then issues a sequence of FILE.DATA.RESPONSE frames with 
increasing block numbers. The FILE.DATA.RESPONSE frames contain a load address
and an execute address and a flag. If the client fails to receive a  
FILE.DATA.RESPONSE frame within a certain period it sends another 
SEND.FILE.REQUEST frame requesting the block which follows the last block that
was successfully received. On the last FILE.DATA.RESPONSE frame the server
sets a special value of the flags which cause the client to transfer execution
to the execute address specified in the frame.
.Pp
The server starts by reading the configuration file in /etc/rpld.conf,
see 
.Pa rpld.conf(5),
After the configuration file has been read, it opens the system's
default network interface and listens for RPL frames.
The server recalculates the length of all the files to be downloaded every time
it receives a SEND.FILE.REQUEST frame. 
.Sh BUGS
.Bl -tag -width 0 -compact
.It
Solenopsis invicta Buren 
.It
rpld (probably) doesn't support the new bzImage format correctly.
.It
rpld doesn't reload the first 512 octets of Linux kernels automatically.
.It
There is no way to make rpld re-read its configuration file.
.It
rpld 
needs to meet more network adapters.
.Sh NOTES
.Pp
IBM is a trademark of IBM Corp.
.Sh FILES
.Bl -tag -width /etc/rpld.conf -compact
.Pp
.It Pa /usr/sbin/rpld
.It Pa /etc/rpld.conf
.It Pa /rplboot
.El
.Sh SEE ALSO
.Pp
.Bl -tag -width 0 -compact
.It Pa rpld\.conf(5),
.It Pa bootpd(1),
.It Pa dhcpd(1),
.It Pa http://bullard.esc.cam.ac.uk/~james/rpld;
.El
.Sh AUTHORS AND COPYRIGHT
.Pp
(c) 1999 James McKenzie, and Christopher Lightfoot. All rights reserved.
