/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: rpld.c,v 1.9 1999/09/13 11:17:35 root Exp $";

/*
 * $Log: rpld.c,v $
 * Revision 1.9  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.8  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.7  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"

static unsigned char RPL_MC_ADDR[ETH_ALEN] =
{0x3, 0x0, 0x2, 0x0, 0x0, 0x0};

int downloading = 0;

int
main (argc, argv)
     int argc;
     char **argv;
{
  unsigned char buf[MAX_FRAME_LEN];
  struct llchdr *h = (struct llchdr *) buf;
  struct timeval last;

  struct nit *n;

  openlog ("rpld", LOG_PID, LOG_DAEMON);

  parse_config ();

  daemonize ();

  n = nit_open (NULL);

  if (!n)
    {
      syslog (LOG_ERR, "failed to initalize nit");
      return (-1);
    }

  nit_multicast (n, RPL_MC_ADDR);

  syslog (LOG_ERR, "my hw addr = %s", ethtoa (nit_mac (n)));


  gettimeofday (&last, NULL);


  while (1)
    {
      int len;
      struct timeval tv;

      if (downloading)
        {
          tv.tv_sec = 0;
          tv.tv_usec = PACKET_DELAY;
        }
      else
        {
          tv.tv_sec = 10;
          tv.tv_usec = 0;
        }

      len = nit_read_packet (n, buf, sizeof (buf), &tv);


      if ((len > LLC_HDR_LEN) && (ntohs (h->h_len) <= 1514))
        {                       /*Short circuit most packets */
          llc_recv_packet (n, buf, len);
        }

      if (downloading)
        {
          gettimeofday (&tv, NULL);

          len = tv.tv_usec;
          len += 1000000;
          len -= last.tv_usec;
          len %= 1000000;

          if (len > 1000)
            {
              client_dispatch (n);
              gettimeofday (&last, NULL);

            }
        }
    }

  nit_close (n);

  return 0;
}
