/********************************************************

	Video decoder interface
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/
#ifndef _videodecoder_h
#define _videodecoder_h

#include <stdio.h>
#include <math.h>

#include <loader.h>

#include <wine/vfw.h>
#include <default.h>
#include <except.h>

#include <image.h>
#include <infotypes.h> 
/**
 *
 *  Class for video decompression.
 *
 *  Usage:
 *    
 *  Init() call tries to load video codec corresponding to your
 * format, and throws FatalError if something goes wrong. 
 *  Start() starts decompression and Stop() stops it.
 *
 * SetBitDepth() sets desired bit depth of output picture. Returns
 * zero on success, -1 if bit depth is unsupported. Most decoders 
 * support depths 16, 24 or 32.
 *
 * DecodeFrame() decodes a single frame. Returns zero on success, any
 * other value on failure. Nonzero here is not fatal ( maybe it was
 * just one defective bit in file, after next keyframe everything 
 * will be OK ).
 *
 */
class IRtConfig
{
public:
    virtual HRESULT GetValue(const char*, int&) =0;
    virtual HRESULT SetValue(const char*, int) =0;
};
class IVideoDecoder
{
public:
    enum CAPS 
    {
     CAP_YUY2=1,
     CAP_YV12=2,
     CAP_IYUV=4,
     CAP_UYVY=8,
     CAP_YVYU=16 };

    static IVideoDecoder* IVideoDecoder::Create(const BITMAPINFOHEADER& bh, int depth=24, int flip=0);
    
    virtual ~IVideoDecoder(){}
    virtual void Start()			=0;
    virtual void Stop()				=0;
    virtual void Restart()			=0;
    virtual CImage* GetFrame();
    virtual const BITMAPINFOHEADER& DestFmt() 	=0;
    virtual int DecodeFrame(char* src, int size, int is_keyframe) =0;
    virtual int SetDestFmt(int bits=24, int csp=0) =0;
    virtual int SetDirection(int dir);
    virtual CAPS GetCapabilities() const {return (CAPS)0;}
    virtual const CodecInfo& GetCodecInfo() const =0;

    static int GetExtendedAttr(const CodecInfo& info, const char* attribute, int& value)
;
    static int SetExtendedAttr(const CodecInfo& info, const char* attribute, int value)
;
protected:
    BITMAPINFOHEADER m_bh;//format of input data
    BitmapInfo m_obh;  //format of output data
    CImage* m_outFrame;//[fields];
};    
#endif
