#include <stdio.h>

#include <windows.h>
#include <commctrl.h>

#include "resource.h"
#include "filter.h"

extern HINSTANCE g_hInst;

///////////////////////////////////

void __declspec(naked) asm_invert_run(Pixel32 *data, long w, long h, long pitch) {
	__asm {
		push	ebp
		push	edi
		push	esi
		push	ebx

		mov		edi,[esp+4+16]
		mov		edx,[esp+8+16]
		mov		ecx,[esp+12+16]
		mov		esi,[esp+16+16]
		mov		eax,edx
		xor		edx,-1
		shl		eax,2
		inc		edx
		add		edi,eax
		test	edx,1
		jz		yloop
		sub		edi,4
yloop:
		mov		ebp,edx
		inc		ebp
		sar		ebp,1
		jz		zero
xloop:
		mov		eax,[edi+ebp*8  ]
		mov		ebx,[edi+ebp*8+4]
		xor		eax,-1
		xor		ebx,-1
		mov		[edi+ebp*8  ],eax
		mov		[edi+ebp*8+4],ebx
		inc		ebp
		jne		xloop
zero:
		test	edx,1
		jz		notodd
		not		dword ptr [edi]
notodd:
		add		edi,esi
		dec		ecx
		jne		yloop

		pop		ebx
		pop		esi
		pop		edi
		pop		ebp
		ret
	};
}

///////////////////////////////////

int invert_run(const FilterActivation *fa, const FilterFunctions *ff) {	
	asm_invert_run(
			fa->src.data,
			fa->src.w,
			fa->src.h,
			fa->src.pitch
			);

	return 0;
}

long invert_param(FilterActivation *fa, const FilterFunctions *ff) {
	return 0;
}

FilterDefinition filterDef_invert={
	0,0,NULL,
	"invert",
	"Inverts the colors in the image.\n\n[Assembly optimized]",
	NULL,NULL,
	0,
	NULL,NULL,
	invert_run,
	invert_param,
	NULL,
	NULL,
};
