#ifndef f_CAPLOG_H
#define f_CAPLOG_H

#include <windows.h>

#include "List.h"

struct CapEvent {
	enum { VIDEO=0, AUDIO } type;
	DWORD dwTimeStampReceived;
	DWORD dwBytes;

	union {
		struct {
			DWORD dwTimeStampRecorded;
		} video;

		struct {
			LONG lVideoDelta;
		} audio;
	};
};

class CapEventBlock : public ListNode2<CapEventBlock> {
public:
	CapEvent ev[256];
};

class CaptureLog {
public:
	CaptureLog();
	~CaptureLog();

	bool LogVideo(DWORD dwTimeStampReceived, DWORD dwBytes, DWORD dwTimeStampRecorded);
	bool LogAudio(DWORD dwTimeStampReceived, DWORD dwBytes, LONG lVideoDelta);
	void Display(HWND hwndParent);
	void Dispose();

private:
	List2<CapEventBlock> listBlocks;
	CapEventBlock *pceb;
	int nEvents;
	int nEventsBlock;

	void GetDispInfo(NMLVDISPINFO *nldi);
	CapEvent *GetNewRequest();

	BOOL DlgProc2(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam);
	static BOOL CALLBACK DlgProc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam);
};

#endif
