#include "filter.h"
#include "filters.h"

extern FilterDefinition filterDef_average, filterDef_reduceby2,
						filterDef_convolute, filterDef_sharpen,
						filterDef_brightcont, filterDef_emboss,
						filterDef_null, filterDef_grayscale,
						filterDef_reduce2hq,
						filterDef_threshold, filterDef_resize,
						filterDef_fill, filterDef_tsoften,
						filterDef_flipv, filterDef_fliph,
						filterDef_tv, filterDef_smoother,
						filterDef_deinterlace,
						filterDef_rotate,
						filterDef_invert,
						filterDef_rotate2,
						filterDef_levels,
						filterDef_fieldswap,
						filterDef_blur,
						filterDef_blurhi;

static FilterDefinition *builtin_filters[]={
	&filterDef_average,
	&filterDef_reduceby2,
	&filterDef_convolute,
	&filterDef_sharpen,
	&filterDef_brightcont,
	&filterDef_emboss,
	&filterDef_null,
	&filterDef_grayscale,
	&filterDef_reduce2hq,
	&filterDef_threshold,
	&filterDef_resize,
	&filterDef_fill,
	&filterDef_tsoften,
	&filterDef_flipv,
	&filterDef_fliph,
	&filterDef_tv,
	&filterDef_smoother,
	&filterDef_deinterlace,
	&filterDef_rotate,
	&filterDef_invert,
	&filterDef_rotate2,
	&filterDef_levels,
	&filterDef_fieldswap,
	&filterDef_blur,
	&filterDef_blurhi,
	NULL
};

void InitBuiltinFilters() {
	FilterDefinition *last=NULL, *cur, **cpp;

	filter_list = NULL;

	cpp = builtin_filters;
	while(cur = *cpp++) {
		if (!last) filter_list = cur;
		else last->next = cur;
		cur->prev = last;

		last = cur;
	}
	last->next = NULL;
}
