#ifndef f_ERROR_H
#define f_ERROR_H

#include <windows.h>
#include <vfw.h>

class MyError {
protected:
	char *buf;

public:
	MyError(MyError& err);
	MyError();
	MyError(const char *f, ...);
	~MyError();
	void setf(const char *f, ...);
	void vsetf(const char *f, va_list val);
	void post(HWND hWndParent, const char *title);
	char *gets() {
		return buf;
	}
	void discard();
};

class MyICError : public MyError {
public:
	MyICError(const char *s, DWORD icErr);
};

class MyMMIOError : public MyError {
public:
	MyMMIOError(const char *s, DWORD icErr);
};

class MyAVIError : public MyError {
public:
	MyAVIError(const char *s, DWORD aviErr);
};

class MyMemoryError : public MyError {
public:
	MyMemoryError();
};

class MyWin32Error : public MyError {
public:
	MyWin32Error(const char *format, DWORD err, ...);
};

class MyCrashError : public MyError {
public:
	MyCrashError(const char *format, DWORD dwExceptionCode);
};

class MyUserAbortError : public MyError {
public:
	MyUserAbortError();
};

#endif
