#ifndef f_ASFINDEX_H
#define f_ASFINDEX_H

#include <stdio.h>
#include <string.h>

#include <windows.h>
#include <vfw.h>

class ASFIndexChainNode;

class ASFIndexEntry {
public:
	__int64 pos;
	long	size;
	long	pres_time;
	unsigned char	seq;
	char	_pad[3];
};

class ASFIndexChain {
protected:
	ASFIndexChainNode *head, *tail;

	void delete_chain();
public:
	int total_ents;

	ASFIndexChain();
	~ASFIndexChain();

	bool add(__int64 pos, long len, bool is_keyframe, long pres_time, unsigned char seq);
	void put(ASFIndexEntry *ASFe2tbl);
};

class ASFIndex : public ASFIndexChain {
protected:
	ASFIndexEntry *index;
	int index_len;

	ASFIndexEntry *allocateIndex(int total_entries) {
		return index = new ASFIndexEntry[1+(index_len = total_entries)];
	}

public:
	ASFIndex();
	~ASFIndex();

	bool makeIndex();
	void clear();

	ASFIndexEntry *indexPtr() {
		return index;
	}

	int size() { return total_ents; }

	int indexLen() {
		return index_len;
	}

	void Transfer(ASFIndex *);
};

#endif