/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: linux-ps.c,v 1.8 2000/07/16 14:24:16 root Exp $";

/* 
 * $Log: linux-ps.c,v $
 * Revision 1.8  2000/07/16 14:24:16  root
 * #
 *
 * Revision 1.7  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.6  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.5  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.4  1999/09/11 16:52:15  root
 * \#
 *
 * Revision 1.3  1999/09/11 16:34:50  root
 * \#
 *
 * Revision 1.2  1999/09/10 22:06:43  root
 * \#
 *
 * Revision 1.1  1999/09/10 17:32:26  root
 * \#
 *
 * Revision 1.1  1999/05/17 21:53:33  root
 * Initial revision
 *
 */

/*
 * CAUTION THIS CODE COMES WITH NO WARARNTY IT IS COPYRIGHT 1999 BY
 * James McKenzie All rights reserved. GPL applies
 */


#include "project.h"

#undef __GLIBC__
#include <linux/socket.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <linux/if_packet.h>
#include <linux/route.h>
#define __GLIBC__



static void
get_hwaddr (unsigned char *name, unsigned char *addr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return;
    }
  bcopy (name, &ifr.ifr_name, sizeof (ifr.ifr_name));


  /* find my own hardware address */
  if (ioctl (fd, SIOCGIFHWADDR, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCGIFHWADDR):%m");
      exit (-1);
    }
  close (fd);


  bcopy (&ifr.ifr_hwaddr.sa_data, addr, ETH_ALEN);

}

void
nit_close (struct nit *n)
{
  if (!n)
    return;

  close (n->fd);
  free (n->name);

/*FIXME: we should demulticast at this point but we need to have some 
 *mechanism for detecting if anyone else wants it
 */

  free (n);
}

struct nit *
nit_open (char *name)
{
  struct nit *n;
  struct sockaddr sa;
  int fd;

  if (!name)
    name = "eth0";

#ifdef PF_PACKET
  fd = socket (PF_PACKET, SOCK_PACKET, htons (ETH_P_ALL));

  if (fd < 0)
#endif
    fd = socket (AF_INET, SOCK_PACKET, htons (ETH_P_ALL));

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return (NULL);
    }

  bzero (&sa, sizeof (sa));
  sa.sa_family = AF_INET;
  memcpy (&sa.sa_data, name, sizeof (sa.sa_data));

  if (bind (fd, &sa, sizeof (sa)) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "bind:%m");
      return (NULL);
    }


  n = (struct nit *) malloc (sizeof (struct nit));

  n->fd = fd;
  n->name = (char *) malloc (MAX_NAME_LEN);
  bzero (n->name, MAX_NAME_LEN);

  strcpy (n->name, name);
  get_hwaddr (n->name, n->mac);

  return (n);
}

void
nit_send_frame (struct nit *n, unsigned char *frame, int len)
{
  struct sockaddr sa;
  struct msghdr msg;
  struct iovec iov;

  bzero (&msg, sizeof (msg));
  bzero (&sa, sizeof (sa));

  sa.sa_family = AF_INET;
  strncpy (sa.sa_data, n->name, sizeof (sa.sa_data));

  if (sendto (n->fd, frame, len, 0, &sa, sizeof (sa)) < 0)
    syslog (LOG_ERR, "sendto: %m");

  return;

}


void
nit_multicast (struct nit *n, unsigned char *mcaddr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  strncpy (ifr.ifr_name, n->name, sizeof (ifr.ifr_name));

  ifr.ifr_hwaddr.sa_family = AF_UNSPEC;

  bcopy (mcaddr, ifr.ifr_hwaddr.sa_data, ETH_ALEN);

  if (ioctl (fd, SIOCADDMULTI, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCADDMULTI):%m");
    }
}

int
nit_read_packet (struct nit *n, char *buf, int len, struct timeval *tv)
{
  fd_set rfds;
  int ret;

  FD_ZERO (&rfds);
  FD_SET (n->fd, &rfds);


  ret = select ((n->fd) + 1, &rfds, NULL, NULL, tv);

  if (ret < 0)
    return (ret);

  if (FD_ISSET ((n->fd), &rfds))
    {

      ret = read (n->fd, buf, len);

      return (ret);
    }
  else
    {
      return (0);
    }

}
