/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] =
  "$Id: client.c,v 1.19 2000/07/23 19:14:19 root Exp root $";

/*
 * $Log: client.c,v $
 * Revision 1.19  2000/07/23 19:14:19  root
 * #
 *
 * Revision 1.18  2000/07/23 19:07:49  root
 * #
 *
 * Revision 1.17  2000/07/17 10:49:20  root
 * #
 *
 * Revision 1.16  2000/07/17 10:45:38  root
 * #
 *
 * Revision 1.15  2000/07/17 10:43:54  root
 * #
 *
 * Revision 1.14  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.13  2000/07/16 14:22:06  root
 * #
 *
 * Revision 1.12  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.11  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.10  1999/09/14 17:12:38  root
 * #
 *
 * Revision 1.9  1999/09/14 17:12:05  root
 * #
 *
 * Revision 1.8  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.7  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.6  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"

struct client *clients = NULL;

void
cache_locally (struct clfile *f)
{
  int fd;
  int len;

  fd = open (f->path, O_RDONLY);

  if (fd < 0)
    {
      syslog (LOG_ERR, "can't open %s:%m", f->path);
      return;
    }

  len = f->length;

  if (len < 0)
    {
      len = lseek (fd, 0, SEEK_END);
      lseek (fd, 0, SEEK_SET);
    }

  f->data = malloc (len);
  f->length = len;

  lseek (fd, f->offset, SEEK_SET);
  read (fd, f->data, len);

  f->offset = 0;

  close (fd);

  free (f->path);
  f->path = NULL;
}

/* Cache the last client */
struct client *
find_client_by_mac (unsigned char *mac)
{
  struct client *pc = NULL, *c = clients;

/* We need to match clients by a (possibly partial) MAC address; however
 * this struct client is also used to transmit to them, so we need to return
 * a struct client containing a _real_ MAC address; this is a first and
 * pretty ugly implementation of this idea.
 */
  while (c)
    {
      if (memcmp (mac, c->mac, c->partial_mac_len) == 0)
        {
          /* if partial match, create new struct client */
          if (c->partial_mac_len != ETH_ALEN)
            {
              pc = (struct client *) malloc (sizeof (struct client));
              memcpy (pc, c, sizeof (struct client));

              pc->next = c->next;
              c->next = clients;
              clients = c;

              return pc;
            }

          /* else reorder the tree for speed, and return the found client */
          if (pc)
            {                   /*Short circuit for next time */
              pc->next = c->next;
              c->next = clients;
              clients = c;
            }
          return (c);
        }

      pc = c;
      c = c->next;
    }

  return (NULL);
}

void
client_calc_offsets (struct client *c)
{
  struct clfile *f;
  int bn = 0;
  int len;
  int fd;
  int blocks;

  f = c->files;

  while (f)
    {

      f->sblock = bn;

      if (f->path)
        {
          fd = open (f->path, O_RDONLY);
          if (fd < 0)
            {
              syslog (LOG_ERR, "can't open %s:%m", f->path);
              return;
            }
          len = f->length;
          if (len < 0)
            {
              len = lseek (fd, 0, SEEK_END);
              len -= f->offset;
            }
          close (fd);
        }
      else
        {
          len = f->length;
        }

#ifdef DEBUG
      printf ("%s is %d bytes long gives", f->path, len);
#endif
      blocks = len / (c->blocklen);
      len = len - (blocks * c->blocklen);

      if (len == 0)
        blocks--;

      bn += blocks;
      f->eblock = bn;

#ifdef DEBUG
      printf (" %d blocks [%d,%d]\n", blocks, f->sblock, f->eblock);
#endif

      bn++;

      f = f->next;

    }

}


#define NOTINRANGE(l,v,h) (((v)<(l)) || ((v)>(h)))
void
client_get_block (struct client *c, struct rpl_packet *p)
{
  struct clfile *f;
  int toread;
  int offset;

  f = c->file;

  p->datalen = 0;               /* Some buggy clients request
                                   * blocks after the end when
                                   * they get confused */

  if ((!f) || (NOTINRANGE (f->sblock, c->blocknum, f->eblock)))
    {
      if ((f) && (f->f))
        {
          fclose (f->f);
          f->f = NULL;
        }
      f = c->files;
      while (f && (f->eblock < c->blocknum))
        f = f->next;

      if (!f)
        {
          syslog (LOG_ERR, "this shouldn't happen oops!");
          return;
        }

      if (f->path)
        {
          f->f = fopen (f->path, "r");
          if (!f->f)
            {
              c->file = NULL;

              syslog (LOG_ERR, "failed to open %s ", f->path);
              return;
            }

        }

      c->file = f;
    }


  offset = (c->blocklen) * (c->blocknum - f->sblock);

  if (f->length > 0)
    {
      toread = f->length - offset;
      if (toread > c->blocklen)
        toread = c->blocklen;
    }
  else
    {
      toread = c->blocklen;
    }

  if (f->path)
    {                           /* A real file */
      fseek (f->f, offset + f->offset, SEEK_SET);
      p->datalen = fread (p->data, 1, toread, f->f);
      if ((p->datalen != toread) && (c->blocknum != f->eblock))
        {
          syslog (LOG_ERR, "short read on %s", f->path);
        }
    }
  else
    {                           /*cached */
      bcopy (f->data + offset, p->data, toread);
      p->datalen = toread;
    }

  p->addr.load = f->load_addr + offset;

}

int
client_last_block (struct client *c)
{
  struct clfile *f;
  f = c->file;

  if ((!f) || (NOTINRANGE (f->sblock, c->blocknum, f->eblock)))
    {
      if ((f) && (f->f))
        {
          fclose (f->f);
          f->f = NULL;
        }
      c->file = NULL;
      f = c->files;
      while (f && (f->eblock < c->blocknum))
        f = f->next;

      if (!f)
        {
          syslog (LOG_ERR, "this shouldn't happen oops!");
          return 1;             /*Infact past the last block */
        }
    }

  if (!(f->next) && (f->eblock == c->blocknum))
    {
      return 1;
    }


  return 0;
}

void
client_flush_cache (struct client *c)
{

  struct clfile *f;
  f = c->file;

  if ((f) && (f->f))
    {
      fclose (f->f);
      f->f = NULL;
      c->file = NULL;
    }

}

clients_check_status ()
{
  struct client *c = clients;

  downloading = 0;
  pacing = 0;

  while (c)
    {
      if ((c->state == ST_FILEDATA) && (!c->nospew))
        {
          downloading++;
          if (pacing < c->pacing)
            pacing = c->pacing;
        }
      c = c->next;
    }

}

client_dispatch (struct nit *n)
{
  struct client *c = clients;

  while (c)
    {
      if ((c->state == ST_FILEDATA) && (!c->nospew))
        {
          file_data_frame (n, c);
        }
      c = c->next;

    }

}
