/********************************************
 * the rtjpeg hack for mpeg2movie by        *
 *                 and nuv2divx             *
 * Roman Hochleitner                        *
 *                                          *
 * roman@mars.tuwien.ac.at                  *
 *                                          *
 ********************************************
 * USE AT YOUR OWN RISK         NO WARRANTY *
 * (might crash your pencil!)               *
 ********************************************
 *                                          *
 * parts borrowed from Justin Schoeman      *
 *                     and others           *
 *                                          *
 * This Software is under GPL version 2     *
 *                                          *
 * http://www.gnu.org/copyleft/gpl.html     *
 * ---------------------------------------- *
 * Fri Feb 16 16:01:21 CET 2001             *
 ********************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#define RTJPEG_INTERNAL 1
 #include "rtjpeg_plugin.h"
#undef RTJPEG_INTERNAL

#include "../rtjpeg/RTjpeg.h"
#include "../rtjpeg/nuppelvideo.h"
#include "minilzo.h"

/* dynamic loading stuff */
#ifdef DYNAMIC_LOADING
//        int (*check_file)(char *)=rtjpeg_check_sig;
int check_file(char *name) { return rtjpeg_check_sig(name); }
int open_file(char *name) { return rtjpeg_open(name); }
int close_file() { return rtjpeg_close() ;}
int eof_file() { return rtjpeg_end_of_video(); }
int get_video_width() { return rtjpeg_get_video_width(); }
int get_video_height() { return rtjpeg_get_video_height(); }
double get_video_framerate() { return rtjpeg_get_video_frame_rate(); }
double get_pel_ratio() { return rtjpeg_pel_ratio(); }

#endif


/*
  int    rtjpeg_file;
  int    rtjpeg_video_width;
  int    rtjpeg_video_height;
  double rtjpeg_video_frame_rate;
*/


/* ------------------------------------------------- */

int rtjpeg_open(char *tplorg)
{
  unsigned long int tbls[128];
  struct rtfileheader fileheader;
  struct rtframeheader frameheader;


  rtjpeg_file=open(tplorg, O_RDONLY);
  read(rtjpeg_file, &fileheader, sizeof(fileheader));
  rtjpeg_video_width      = fileheader.width;
  rtjpeg_video_height     = fileheader.height;
  rtjpeg_video_frame_rate = fileheader.fps;

  /* first frame has to be the Compression "D"ata frame */
  read(rtjpeg_file, &frameheader, sizeof(frameheader));
  if (frameheader.frametype != 'D') {
    fprintf(stderr, "Illegal File Format, no Compression(D)ata frame" );
    exit(1);
  }
  read(rtjpeg_file, tbls, frameheader.packetlength);
  RTjpeg_init_decompress(tbls, rtjpeg_video_width, rtjpeg_video_height);

  if ((rtjpeg_video_height & 1) == 1) {
    rtjpeg_video_height--;
    fprintf(stderr, "\nIncompatible video height, reducing height to %d\n", rtjpeg_video_height);
  }

  /* init compression lzo ------------------------------ */
  if (lzo_init() != LZO_E_OK)
  {
    fprintf(stderr,"%s\n", "lzo_init() failed !!!");
    exit(3);
  }

  return(0);
}



/* ------------------------------------------------- */

unsigned char *rtjpeg_get_frame(int number, char *frametype, int onlyvideo, int *audiolen)
{
  int tmp,r, cnt=0;
  unsigned int out_len;
  struct rtframeheader frameheader;
  int compoff = 0;
  static unsigned char *buf2 = 0;

  // FIXME number is not used

  static unsigned char *strm = 0;
  long tf=0; int gotit=0;

  if (rtjpeg_rgb==NULL) {
    rtjpeg_buf = (unsigned char *) malloc( rtjpeg_video_width*rtjpeg_video_height +
                        (rtjpeg_video_width*rtjpeg_video_height)/2);
    strm       = (unsigned char *) malloc( rtjpeg_video_width*rtjpeg_video_height +
                        (rtjpeg_video_width*rtjpeg_video_height)/2);
    rtjpeg_rgb = (unsigned char *) malloc(rtjpeg_video_width*rtjpeg_video_height*3+8192); /* +8192 just be sure */
    buf2       = (unsigned char *) malloc( rtjpeg_video_width*rtjpeg_video_height +
                        (rtjpeg_video_width*rtjpeg_video_height)/2);
    /* fprintf(stderr, "%s\n", "after mallocing rgb-space"); */
  }

  /* fprintf(stderr, "%s\n", "before reading framesize"); */

  gotit = 0;

  while (!gotit) {
    if (read(rtjpeg_file, &frameheader, sizeof(frameheader))!=sizeof(frameheader)) {
      rtjpeg_eof=1;
      return(rtjpeg_buf);
    }

    // fprintf(stderr,"\ntype='%c' ctype='%c' length=%d", frameheader.frametype,
    //                                                    frameheader.comptype,
    //                                                    frameheader.packetlength);


    if (frameheader.frametype=='V') gotit=1;
    if (frameheader.frametype=='A' && onlyvideo==0) gotit=1;

    if (frameheader.frametype == 'R') continue; // the R-frame has no data packet
    // fix bug in old version, future: never use V-Comprtype 'L'
    if (frameheader.frametype == 'V' && frameheader.comptype=='L') frameheader.frametype='L';
    if (frameheader.frametype == 'N' || frameheader.frametype == 'L') {
      // we intreprete Null frames as lastframes
      return(rtjpeg_buf);
    }

    if(read(rtjpeg_file, strm, frameheader.packetlength)!=frameheader.packetlength) {
      rtjpeg_eof=1;
      return(rtjpeg_buf);
    }
  }
  *frametype = frameheader.frametype;
  if (frameheader.frametype=='A')  *audiolen = frameheader.packetlength;
                             else  *audiolen = 0;

  if (frameheader.frametype=='A') return(rtjpeg_buf);

  /* fprintf(stderr, "%s\n", "after reading frame"); */

  if (frameheader.comptype == '2') compoff=0;
  if (frameheader.comptype == '1') compoff=1;

  if (frameheader.frametype=='V' && frameheader.comptype == '0') {
    fprintf(stderr, "we don't support YUV420 frames, although we should");
    exit(1);
  }

  // lzo decompression ------------------
  if (!compoff) {
    r = lzo1x_decompress(strm,frameheader.packetlength,buf2,&out_len,NULL);
    if (r != LZO_E_OK) {
      // if decompression fails try raw format :-)
      fprintf(stderr,"\nminilzo: can't decompress illegal data\n");
    }
  }

  if (compoff) {
    RTjpeg_decompressYUV420((__s8 *)strm, rtjpeg_buf); 
  } else {
    RTjpeg_decompressYUV420((__s8 *)buf2, rtjpeg_buf);
  }

  /* fprintf(stderr, "%s\n", "after decompressing frame"); */

  // we use yuv420 now RTjpeg_yuvrgb24(rtjpeg_buf, rtjpeg_rgb, 0); /* rgb24 will work */
  /* fprintf(stderr, "%s\n", "after rgb-ing frame"); */
  
  cnt++;

  if (cnt % 10 == 0) usleep(250000); // give time to system to prevent system locking :-/

  return(rtjpeg_buf);
}



/* ------------------------------------------------- */

int rtjpeg_close()
{
  close(rtjpeg_file);
  return(0);
}


/* ------------------------------------------------- */

int rtjpeg_get_video_width()
{
  return(rtjpeg_video_width);
}



/* ------------------------------------------------- */

int rtjpeg_get_video_height()
{
  return(rtjpeg_video_height);
}



/* ------------------------------------------------- */

double rtjpeg_get_video_frame_rate()
{
  return(rtjpeg_video_frame_rate);
}



/* ------------------------------------------------- */
/* we don't really check sig, just the extension     */

int rtjpeg_check_sig(char *fname)
{
  int len;

  len=strlen(fname);
  if (len < 4)
    return(0);
  if ((0 == strcmp(fname+len-6,".rtjpg")) || 
      (0 == strcmp(fname+len-6,".RTJPG")) ||
      (0 == strcmp(fname+len-4,".rtj")) || 
      (0 == strcmp(fname+len-4,".nuv")) || 
      (0 == strcmp(fname+len-4,".NUV")) || 
      (0 == strcmp(fname+len-4,".RTJ")))
    return(1);
  return(0);
}



/* ------------------------------------------------- */

int rtjpeg_end_of_video()
{
   return (rtjpeg_eof);
}

int rtjpeg_pel_ratio()
{
/* might even work, at least as far as the mpeg rates go */
/*   return ((float)rtjpeg_get_video_width()/384.0*270.0/(float)rtjpeg_get_video_height()); */
	return 0.0; /* can't be sure anyway ... */
}


