#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#include "global.h"

/* aspect ratio calculation since ar now is float, not int */
/* 1=square pel, 2=4:3, 3=16:9, 4=2.11:1 */
int aspect_code_calc(float ar)
{ 
	float atmp, amin=10000.0; 
	int code=0; 
	
        if ((atmp=(1.0-ar/1.0)) < amin) { 
		code=1; 
		amin=atmp; 
	} 
	if ((atmp=(1.0-ar*4.0/3.0)) < amin) { 
		code=2; 
		amin=atmp; 
	}; 
	if ((atmp=(1.0-ar*16.0/9.0)) < amin) { 
		code=3; 
		amin=atmp; 
	}; 
	if ((atmp=(1.0-ar*2.11)) < amin) { 
		code=4; 
		amin=atmp; 
	}; 
	return code;
}

