#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#include "global.h"
#include "aviplugin.h"
#include "../rtjpeg/RTjpeg.h"
#include "areaDeinterlace.h"

#include "rtjpeg_plugin.h"

/* dynamic loading stuff */
#if defined(DYNAMIC_LOADING) 
/* dummy symbol for telling the plugin architecture we can load video */
int video_in(void)
{
	return 1;
}

void read_rtjpeg(unsigned char **frame, unsigned int number);

void read_frame(unsigned char **frame, unsigned int number)
{
	read_rtjpeg(frame,number);
}
//void (*read_frame)(unsigned char **, int)=read_rtjpeg;

#endif

void border_extend(frame,w1,h1,w2,h2);

/* ----------------------------------------------------------- */
/* yuv420 version for speed                                    */
/* ----------------------------------------------------------- */

void read_rtjpeg(frame, number)
unsigned char *frame[];
unsigned int number;
{
  int xpos,ypos,f,tmp;
  unsigned char *dst = NULL;
  char buf[32];
  char frametype[1]; // dummy for rtjpeg_get_frame
  int audiolen;

  int i, j;
  char name[128];
  int yuv_size_y;
  int yuv_size_uv;
  unsigned char *p_yuv;

  static      char *ppm[4] = { NULL,NULL,NULL,NULL };
  static int   mostrecentp = 0;
  static int    mostrecent = 0;
  static size_t    bufsize;


  // fprintf(stderr," chroma444=%d  chroma422=%d  chroma420=%d chroma=%d\n",
  //         CHROMA444, CHROMA422, CHROMA420, chroma_format);

#ifndef DYNAMIC_LOADING
  if (chroma_format != CHROMA420) {
    fprintf(stderr, "\n%s\n\n", "rtjpeg_plugin only supports YUV420!, sorry");
    exit(1);
  }
#endif
  if (!mostrecent) { // first frame to encode, number may be != 0
    bufsize = rtjpeg_get_video_height()*rtjpeg_get_video_width()*1.5; // we get YUV420
    ppm[0]=(char *)malloc(bufsize);
    ppm[1]=(char *)malloc(bufsize);
    ppm[2]=(char *)malloc(bufsize);
    ppm[3]=(char *)malloc(bufsize);
    mostrecentp=1;
  }
  
  fprintf(stderr,"\nframenum: %i\n",number);
  while (mostrecent < number) {
    mostrecentp=(mostrecentp + 1) % 4;
    mostrecent++;
    p_yuv = rtjpeg_get_frame(mostrecent, frametype, 1, &audiolen); // we want only video frames 
    memcpy(ppm[mostrecentp],p_yuv,bufsize);
//    fprintf(stderr,"\nread frame %i into buffer %i\n",mostrecent,mostrecentp);
  }
  p_yuv=ppm[(mostrecentp - (mostrecent - number) + 4)%4];

//  p_yuv = rtjpeg_get_frame();
  
  // if rtjpeg end of file
#ifndef DYNAMIC_LOADING
  if(rtjpeg_end_of_video()) {
    frames_scaled = 0; /* Terminate encoding */
    // fprintf(stderr, "%s nframes=%d\n", "end of file in rtjpg", nframes);
  }
#endif


  // now we copy the yuv picture to the parial frames frame[0..2]

  yuv_size_y  = rtjpeg_get_video_width()*rtjpeg_get_video_height();
  yuv_size_uv = yuv_size_y >> 2;

  memcpy(frame[0], (void *) p_yuv, yuv_size_y);

  memcpy(frame[1], (void *)(p_yuv+yuv_size_y), yuv_size_uv);
  memcpy(frame[2], (void *)(p_yuv+yuv_size_y+yuv_size_uv), yuv_size_uv);

 // memset(frame[1], 127, yuv_size_uv);
 // memset(frame[2], 127, yuv_size_uv);
 
  // free (is hopefully done by rtjpeg_get_frame() ??

//  border_extend(frame[0],horizontal_size,vertical_size,width,height);
//  border_extend(frame[1],horizontal_size,vertical_size,width,height);
//  border_extend(frame[2],horizontal_size,vertical_size,width,height);
}

