#ifndef INFOTYPES_H
#define INFOTYPES_H

#include <vector>
#include <string>
#include <map>
#include <loader.h>
#include <com.h>
struct AttributeInfo
{
    enum Kind {Integer, String, Select};

    std::string name;
    std::string about;
    Kind kind;
    std::vector<std::string> options;
    int i_min, i_max;
    AttributeInfo(){}
    AttributeInfo(const char* n):name(n), about(n), kind(Integer), i_min(0), i_max(-1){}
    AttributeInfo(std::string n):name(n), about(n), kind(Integer), i_min(0), i_max(-1){}
    AttributeInfo(const char* n, const char* a, const char** o)
	:name(n), about(a), kind(Select)
    {
	while(*o)
	{
	    options.push_back(*o);
	    o++;
	}    
    }
    AttributeInfo(const char* n, const char* a, Kind k, int minval=0, int maxval=-1)
	:name(n), about(a), kind(k), i_min(minval), i_max(maxval){}
};

struct CodecInfo
{
    int fourcc;
    std::vector<int> fourcc_array;
    std::string text;
    std::string about;
    std::string dll;
    enum Kind {Win32, Source, Plugin, DShow_Dec};
    Kind kind;
    vector<AttributeInfo> decoder_info;
    vector<AttributeInfo> encoder_info;
    GUID* guid;
    CodecInfo(){}
    CodecInfo(int* array, const char* info, const char* path, const char* a,
     Kind _kind, GUID* id=0, const vector<AttributeInfo>& ei=vector<AttributeInfo>(), 
     const vector<AttributeInfo>& di=vector<AttributeInfo>())
	:kind(_kind), dll(path), text(info), about(a), fourcc(array[0]), decoder_info(di), encoder_info(ei), guid(id)
    {
	if(!*array) // uncompressed codec
	{
	    fourcc_array.push_back(0);
	    return;
	}
	while(*array)
	{
	    fourcc_array.push_back(*array);
	    array++;
	}    
    }
    static const CodecInfo* match(int codec, const CodecInfo* start=0);
};    

struct VideoEncoderInfo
{
    int quality;
    int keyfreq;
    int compressor;
    BITMAPINFOHEADER header;
};    

#endif