/********************************************************

	Declaration of internal audio class
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/


#ifndef AUDIOENC_IMPL
#define AUDIOENC_IMPL

#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_
typedef struct _WAVEFORMATEX {
  short   wFormatTag;
  short   nChannels;
  long  nSamplesPerSec;
  long  nAvgBytesPerSec;
  short   nBlockAlign;
  short   wBitsPerSample;
  short   cbSize;
} WAVEFORMATEX, *PWAVEFORMATEX, *NPWAVEFORMATEX, *LPWAVEFORMATEX;
#endif

class IAudioEncoder
{
public:
    static IAudioEncoder* Create(int fourcc, WAVEFORMATEX* fmt);
    virtual ~IAudioEncoder(){}
    virtual int SetBitrate(int bitrate) =0;
    virtual int SetQuality(int quality) =0;
    virtual int GetFormatSize() =0;
    virtual int GetFormat(char* extension, int size) =0;
    virtual int Start() =0;
    virtual int Convert(char* in_data, int in_size,
	     char* out_data, int out_size,
	    int* size_read, int* size_written) =0;
	//in_size & size_read in samples    
	
    virtual int Close(char* out_data, 
		int out_size, int* size_written) =0;
};	      

#endif
