/**************************************************************************

	Example of IAviReadFile & IAviReadStream interface usage.
	Copyright 2000 Eugene Kuznetsov (divx@euro.ru)
	
**************************************************************************/


#include <avifile.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>
#include <wine/vfw.h>
#include <aviplay.h>
#include <except.h>
#include <version.h>
#include <errno.h>
#include "audio.h"
#include <libio.h>
#include <stdio.h>
#include "st.h"
#include "resample.h"
#define __MODULE__ "decoder"

#define MY_BUFSIZE 50000

pid_t dec_pid, scal_pid;
char *outfile;

int main(int argc, char** argv)
{
    FILE* f=0;
    int fo,ftmp,scalin[2],outpipe[2];
    IAviReadFile* ac=0;
    IAviReadStream* as=0;
    char* zz=0, *temp=0;
    IAudioRenderer* ar=0;
    audio_queue* aq=0;
    WAVEFORMATEX owf,iwf;
    short *wordp, iword[MY_BUFSIZE],oword[MY_BUFSIZE];
    char *ip;
    int isamp=0,osamp=0;
    int irate, orate;
    long isum, osum;
    int i,start=0;

    
    double tt=0.0,ft;
    if(GetAvifileVersion()!=AVIFILE_VERSION)
    {
	cout<<"This binary was compiled for Avifile ver. "<<AVIFILE_VERSION<<", but the library is ver. "<<GetAvifileVersion()<<". Aborting."<<endl;
	return 0;
    }	
    try
    {
        Unsigned samp_read, bytes_read;
//	f=fopen("./log2.mp3", "wb");
	if (argc<3) {
	  fprintf(stderr,"usage: %s infile.avi {outfile.raw|\"|encodingprogram\"}\n\nunfortunately libavifile currently produces too much debugging output to decode\nto stdout, force with /dev/stdout or specify a program to run with |\n",argv[0]);
	  exit(1);
	}
	
	ac=CreateIAviReadFile(argv[1]);
        as=ac->GetStream(0, AviStream::Audio);
	aq=new audio_queue();
        zz=new char[5000];
	temp=new char[5000000];

	if (pipe(scalin)) {
	  perror("scaler pipes");
	  exit(1);
	}

	if (argv[2][0] == '|') {
	  if (pipe(outpipe)) {
	    perror("pipe");
	    exit(1);
	  }
	  if ((dec_pid=fork()) == 0) {
	    char *s=&argv[2][1];
	    close(0);
	    dup2(0,outpipe[0]);
            close(outpipe[1]);
	    system(s);
            // close(outpipe[1]);
	    exit(errno);
	  } else if (dec_pid < 0) {
	    perror("fork");
	    exit(1);
	  }
	  ftmp=outpipe[1];
//	  close(outpipe[0]);
	} else {
	  ftmp=open(argv[2],O_RDWR|O_CREAT,0644);
        }
	fo=scalin[1];
	    
	ar=new File_AudioRenderer(as,fo);
	printf("Audio Format: %s\n",ar->GetAudioFormat());
	ft=ar->buffer_time();
	ar->start();
	as->GetOutputFormat(&owf, sizeof owf);
	owf.nSamplesPerSec=44100;
	owf.wBitsPerSample=16;
	owf.nChannels=2;
	as->SetOutputFormat();
	as->GetOutputFormat(&owf, sizeof owf);
	fprintf(stderr,	
		"*********************************\n"
		"getTime at start:     %i (%i)\n"
		"nSamplesPerSec:       %10i\n"
		"wBitsPerSample:       %10i\n"
		"nChannels:            %10i\n"
		"*********************************\n",
		ar->getTime(),
		owf.nSamplesPerSec,owf.wBitsPerSample,owf.nChannels);

	irate=owf.nSamplesPerSec;
	orate=44100;
	if (1/*irate != orate || owf.wBitsPerSample != 16 || owf.nChannels != 2*/) {
	  if ((scal_pid=fork()) == 0) {
	    int iamount;
	    short *wordp,*stereop;
	    char *bp,*bwp;
	    LONG *Lp;

	    char *s=&argv[2][1];
	    close(0);
            close(scalin[1]);
            close(outpipe[0]);
	    resample_init(irate,orate);
	    ip=(char *)iword;
	    isum=osum=0;
	    iamount=((((irate>>3)<<1)*owf.wBitsPerSample)/16*owf.nChannels)/2;
	    if (iamount < 1024)
	    	iamount = 1024;
	    // read less if ! 16 bps or 2 channels
	    while ((isamp=read(scalin[0],ip,iamount))>0) {
	            if (owf.wBitsPerSample != 16) { // aargh, convert to 16 bps
		    	bp=((char *)(ip))+isamp;
			wordp=((short *)(ip))+isamp;
		    	for (; bp>=(char *)ip; bp--) {
				*(unsigned short *)(wordp--)=(*(signed char *)bp*0x100-0x8000);
			}
		    } else {
		    	isamp >>= 1;
		    }
	            if (owf.nChannels != 2) { // aargh, convert to fake stereo
		    	for (stereop=((short *)(ip))+2*isamp,wordp=((short *)(ip))+isamp; wordp>=(short *)ip; wordp--) {
				*(stereop--)=*wordp;
				*(stereop--)=*wordp;
			}
		    } else {
		        isamp >>= 1;
		    }
		    isum += isamp;
//		    fprintf(stderr,"read %i, ",isamp);
		    osamp=resample_flow(ip, isamp, (char *)&oword);
		    osum += osamp;
		    write (ftmp,oword,osamp*4);
//		    fprintf(stderr,"wrote %i\n",osamp);
	    }
	    if (isamp < 0) 
		    perror("read samples");

	    osamp=resample_stop((char *)&oword);
	    write (outpipe[1],oword,osamp*4);
//	    fprintf(stderr,"drain: %i\n",osamp*4);
	    osum += osamp;
	    fprintf(stderr,"scaler total: in %li, out %li\n",isum,osum);

            close(scalin[0]);
            close(outpipe[1]);
	    exit(errno);
	  } else if (scal_pid < 0) {
	    perror("fork");
	    exit(1);
	  }
	} /* scalin */  
		while (!as->Eof()) {
	    ar->doAudioExtract(ar->getTime());
	       
	}
    }
    catch(FatalError& error)
    {
	error.Print();
    }	
    if(f)fclose(f);
    if(ac)delete ac;
    if(zz)delete zz;	
}    
