#ifndef FUNCPROTOS_H
#define FUNCPROTOS_H

#include "graphics.h"

/* atom handling routines */
long quicktime_atom_read_size(char *data);
long quicktime_atom_read_size64(char *data);

quicktime_trak_t* quicktime_add_track(quicktime_moov_t *moov);
float quicktime_read_fixed32(quicktime_t *file);
float quicktime_read_fixed16(quicktime_t *file);
long quicktime_read_int32(quicktime_t *file);
long quicktime_read_int24(quicktime_t *file);
long quicktime_position(quicktime_t *file);
int quicktime_write_fixed32(quicktime_t *file, float number);
int quicktime_write_char(quicktime_t *file, char x);
int quicktime_write_int16(quicktime_t *file, int number);
int quicktime_write_int24(quicktime_t *file, long number);
int quicktime_write_int32(quicktime_t *file, long value);
int quicktime_write_char32(quicktime_t *file, char *string);
int quicktime_write_fixed16(quicktime_t *file, float number);
int quicktime_write_data(quicktime_t *file, char *data, int size);
void quicktime_write_pascal(quicktime_t *file, char *data);

/* Most codecs don't specify the actual number of bits on disk in the stbl. */
/* Convert the samples to the number of bytes for reading depending on the codec. */
long quicktime_samples_to_bytes(quicktime_trak_t *track, long samples);

extern void quicktime_init_codec_raw(quicktime_video_map_t *);
extern void quicktime_init_codec_jpeg(quicktime_video_map_t *);
extern void quicktime_init_codec_png(quicktime_video_map_t *);
extern void quicktime_init_codec_yuv2(quicktime_video_map_t *);
extern void quicktime_init_codec_yuv4(quicktime_video_map_t *);
extern void quicktime_init_codec_dv(quicktime_video_map_t *);

extern void quicktime_init_codec_twos(quicktime_audio_map_t *);
extern void quicktime_init_codec_rawaudio(quicktime_audio_map_t *);
extern void quicktime_init_codec_ima4(quicktime_audio_map_t *); 
extern void quicktime_init_codec_ulaw(quicktime_audio_map_t *); 


/* Graphics */
quicktime_scaletable_t* quicktime_new_scaletable(int input_w, int input_h, int output_w, int output_h);


/* chunks always start on 1 */
/* samples start on 0 */

/* update the position pointers in all the tracks after a set_position */
int quicktime_update_positions(quicktime_t *file);



int quicktime_trak_init_audio(quicktime_t *file, 
							quicktime_trak_t *trak, 
							int channels, 
							int sample_rate, 
							int bits, 
							char *compressor);
int quicktime_trak_init_video(quicktime_t *file, 
							quicktime_trak_t *trak, 
							int frame_w, 
							int frame_h, 
							float frame_rate,
							char *compressor);
int quicktime_trak_delete(quicktime_trak_t *trak);
int quicktime_trak_dump(quicktime_trak_t *trak);
int quicktime_delete_trak(quicktime_moov_t *moov);
int quicktime_read_trak(quicktime_t *file, quicktime_trak_t *trak, quicktime_atom_t *trak_atom);
int quicktime_write_trak(quicktime_t *file, quicktime_trak_t *trak, long moov_time_scale);
long quicktime_track_end(quicktime_trak_t *trak);
/* the total number of samples in the track depending on the access mode */
long quicktime_track_samples(quicktime_t *file, quicktime_trak_t *trak);
/* queries for every atom */
/* the starting sample in the given chunk */
long quicktime_sample_of_chunk(quicktime_trak_t *trak, long chunk);
/* the byte offset from mdat start of the chunk */
long quicktime_chunk_to_offset(quicktime_trak_t *trak, long chunk);
/* the chunk of any offset from mdat start */
long quicktime_offset_to_chunk(long *chunk_offset, quicktime_trak_t *trak, long offset);
/* total bytes between the two samples */
long quicktime_sample_range_size(quicktime_trak_t *trak, long chunk_sample, long sample);
int quicktime_chunk_of_sample(long *chunk_sample, long *chunk, quicktime_trak_t *trak, long sample);
/* converting between mdat offsets to samples */
long quicktime_sample_to_offset(quicktime_trak_t *trak, long sample);
long quicktime_offset_to_sample(quicktime_trak_t *trak, long offset);
quicktime_trak_t* quicktime_add_trak(quicktime_moov_t *moov);
/* update all the tables after writing a buffer */
/* set sample_size to 0 if no sample size should be set */
int quicktime_update_tables(quicktime_t *file, 
							quicktime_trak_t *trak, 
							long offset, 
							long chunk, 
							long sample, 
							long samples, 
							long sample_size);
int quicktime_trak_duration(quicktime_trak_t *trak, long *duration, long *timescale);
int quicktime_trak_fix_counts(quicktime_t *file, quicktime_trak_t *trak);
/* number of samples in the chunk */
long quicktime_chunk_samples(quicktime_trak_t *trak, long chunk);
int quicktime_trak_shift_offsets(quicktime_trak_t *trak, long offset);
void quicktime_mhvd_init_video(quicktime_t *file, quicktime_mvhd_t *mvhd, float frame_rate);
void quicktime_stsd_init_video(quicktime_t *file, 
								quicktime_stsd_t *stsd, 
								int frame_w,
								int frame_h, 
								float frame_rate,
								char *compression);
void quicktime_stsd_init_audio(quicktime_t *file, 
							quicktime_stsd_t *stsd, 
							int channels,
							int sample_rate, 
							int bits, 
							char *compressor);
void quicktime_stbl_init_video(quicktime_t *file, 
								quicktime_stbl_t *stbl, 
								int frame_w,
								int frame_h, 
								int time_scale, 
								float frame_rate,
								char *compressor);
void quicktime_stbl_init_audio(quicktime_t *file, 
							quicktime_stbl_t *stbl, 
							int channels, 
							int sample_rate, 
							int bits, 
							char *compressor);
void quicktime_minf_init_video(quicktime_t *file, 
								quicktime_minf_t *minf, 
								int frame_w,
								int frame_h, 
								int time_scale, 
								float frame_rate,
								char *compressor);
void quicktime_minf_init_audio(quicktime_t *file, 
							quicktime_minf_t *minf, 
							int channels, 
							int sample_rate, 
							int bits, 
							char *compressor);
void quicktime_mdia_init_video(quicktime_t *file, 
								quicktime_mdia_t *mdia,
								int frame_w,
								int frame_h, 
								float frame_rate,
								char *compressor);
void quicktime_mdia_init_audio(quicktime_t *file, 
							quicktime_mdia_t *mdia, 
							int channels,
							int sample_rate, 
							int bits, 
							char *compressor);
void quicktime_tkhd_init_video(quicktime_t *file, 
								quicktime_tkhd_t *tkhd, 
								int frame_w, 
								int frame_h);
quicktime_trak_t* quicktime_add_trak(quicktime_moov_t *moov);
int quicktime_delete_trak(quicktime_moov_t *moov);
int quicktime_get_timescale(float frame_rate);

unsigned long quicktime_current_time(void);

#endif
